@extends('admin.layouts.app')

@section('title','Riwayat Gaji')

@section('content')

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="fw-bold mb-1">Riwayat Gaji</h4>
        <small class="text-muted">Rekap dan perhitungan gaji karyawan</small>
    </div>

{{-- <a href="{{ route('admin.gaji.slip', $g->id) }}"
   class="btn btn-sm btn-info">
   <i class="fas fa-file-invoice"></i> Slip
</a> --}}

    <a href="{{ route('admin.gaji.create') }}" class="btn btn-primary btn-sm d-flex align-items-center">
        <i class="fas fa-plus me-2"></i> Hitung Gaji
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card shadow-sm border-0">
    <div class="card-body">

        <table class="table table-hover align-middle">
    <thead class="table-light">
        <tr>
            <th>#</th>
            <th>Karyawan</th>
            <th>Bulan</th>
            <th>Tahun</th>
            <th>Hadir</th>
            <th>Gaji Harian</th>
            <th>Total Gaji</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        @forelse($gaji as $g)
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ $g->karyawan->user->nama }}</td>
            <td>
                {{ \Carbon\Carbon::create()->month($g->bulan)->locale('id')->monthName }}
            </td>
            <td>{{ $g->tahun }}</td>
            <td>
                <span class="badge bg-success">
                    {{ $g->total_hadir }} Hari
                </span>
            </td>
            <td>
                Rp {{ number_format($g->gaji_harian, 0, ',', '.') }}
            </td>
            <td class="fw-semibold text-primary">
                Rp {{ number_format($g->total_gaji, 0, ',', '.') }}
            </td>
            <td>
    <a href="{{ route('admin.gaji.slip', $g->id) }}"
       class="btn btn-sm btn-outline-primary">
        <i class="fas fa-file-pdf"></i> Slip
    </a>
</td>

        </tr>
        @empty
        <tr>
            <td colspan="7" class="text-center text-muted py-4">
                Belum ada data gaji
            </td>
        </tr>
        @endforelse
    </tbody>
</table>

    </div>
</div>

@endsection
